/*
 * Copyright (c) 1999-2001 Lutris Technologies, Inc. All Rights
 * Reserved.
 * 
 * This source code file is distributed by Lutris Technologies, Inc. for
 * use only by licensed users of product(s) that include this source
 * file. Use of this source file or the software that uses it is covered
 * by the terms and conditions of the Lutris Enhydra Development License
 * Agreement included with this product.
 * 
 * This Software is distributed on an "AS IS" basis, WITHOUT WARRANTY OF
 * ANY KIND, either express or implied. See the License for the specific terms
 * governing rights and limitations under the License.
 * 
 * Contributor(s):
 * 
 * $Id: Parser.java,v 1.1.1.1 2001/01/05 05:11:17 sese0235 Exp $
 */

package de.kxml.parser;

import java.io.IOException;
import java.util.*;
import de.kxml.*;

/**
 * An interface definition for a parser that can be pulled for
 * document events.
 */
public abstract class Parser {
    protected boolean processNamespaces = true;

    /**
     * ignores the complete subtree of the given element
     */
    public void ignoreTree(StartTag start) throws IOException {
	while (true) {
	    ParseEvent event = read();

	    switch (event.getType()) {

	    case Xml.START_TAG:
		ignoreTree((StartTag) event);

		break;

	    case Xml.END_TAG:

	    case Xml.END_DOCUMENT:
		return;
	    }
	} 
    } 

    /**
     * Method declaration
     *
     *
     * @return
     *
     * @see
     */
    public int getLineNumber() {
	return -1;
    } 

    /**
     * reads the next event available from the parser. If the end of
     * the parsed stream has been reached, null is returned.
     */
    public abstract ParseEvent read() throws IOException;

    /**
     * reads the next event available from the parser
     * without consuming it
     */
    public abstract ParseEvent peek();

    /**
     * queries the type of the next parsing event. Types are defined in
     * DocumentEvent. convenience method for peek ().getType ().
     */
    public int peekType() {
	return peek().getType();
    } 

    /**
     * tells the parser if it shall resolve namespace prefixes to
     * namespaces. Default is true
     */
    public void setProcessNamespaces(boolean processNamespaces) {
	this.processNamespaces = processNamespaces;
    } 

    /**
     * Convenience method for reading text content. Reads text until
     * an EndTag or EndDocument is reached.  The EndTag is consumed, too.
     * The concatenated text String is returned. If the
     * method reaches an StartTag, an Exception is thrown
     */
    public String readText() throws IOException {
	StringBuffer buf = new StringBuffer();

	while (true) {
	    ParseEvent event = read();

	    switch (event.getType()) {

	    case Xml.START_TAG:
		throw new RuntimeException("Illegal StartTag in readText: " 
					   + event);

	    case Xml.TEXT:
		buf.append(((TextEvent) event).getText());

		break;

	    case Xml.END_TAG:

	    case Xml.END_DOCUMENT:
		return buf.toString();
	    }
	} 
    } 

}

